#!/bin/bash
dialog --title "Raspbmc Installer" --infobox "Please wait a minute while Raspbmc is set up\n\nStep 1 of 2" 5 50
rm /etc/dropbear/*host_key > /dev/null 2>&1
dropbearkey -f /etc/dropbear/dropbear_rsa_host_key -t rsa > /dev/null 2>&1
dropbearkey -f /etc/dropbear/dropbear_dss_host_key -t dss > /dev/null 2>&1
echo -e "raspberry\nraspberry" | smbpasswd -a -s pi
dbus-uuidgen --ensure > /dev/null 2>&1
depmod
pycompile -f /scripts/ > /dev/null 2>&1
MEM=$(cat /proc/meminfo | grep MemTotal | awk '{print $2}')
piRAM=$(($MEM / 1024))
if [ $piRAM -lt 200 ]
then
touch /home/pi/.enable_swap
fi
ROOT_DEV="/dev/mmcblk0"
for line in `cat /proc/cmdline`; do 
  root=$(echo $line | grep "root=" | sed -e "s/root=//")
  if [ "x$root" != "x" ]; then
    SD=$(echo $root | grep mmcblk)
    NFS=$(echo $root | grep nfs)
    if [ "x$SD" == "x" ] && [ "x$nfs" == "x" ]; then
       ROOT_DEV=$(echo $root | sed -e 's/[0-9]$//')
       touch /scripts/upd_sys/.USB
       sed -e "s/\/dev\/mmcblk0p2/$(echo $root | sed -e 's/\//\\\//g')/" -i /etc/fstab
    fi
    if [ "x$NFS" != "x" ]; then
       touch /scripts/upd_sys/.NFS
       sed -e "s/mmcblk0p2/nfs/" -i /etc/fstab
       sed -e "s/ext4/auto/" -i /etc/fstab
    fi
  fi
done
if [ "x$NFS" == "x" ] && [ ! -f /scripts/upd_hist/.NOOBS ]; then
  logger -t run_once "Pre-resize. Deleting 2nd paration and then create it again on "${ROOT_DEV}
fdisk $ROOT_DEV <<EOF
p
d
2
n
p
2
151552

p
w
EOF
fi
touch /scripts/upd_hist/ftr-configured
rm /runonce.sh
if [ "x$NFS" == "x" ] && [ ! -f /scripts/upd_hist/.NOOBS ] ; then
  ln -s /standalone-01.sh /runonce.sh
else
  mv /etc/init/xbmc.conf.bk /etc/init/xbmc.conf
  mv /etc/init/update-checker.conf.bk /etc/init/update-checker.conf
  if [ -f /scripts/upd_hist/.NOOBS ]
  then
	# Avoid recovery menu on NOOBS reboot
	PNUM=$(cat /etc/fstab | grep vfat | awk {'print $1'} | cut -d 'p' -f 2)
	echo ${PNUM} > /sys/module/bcm2708/parameters/reboot_part
  fi
fi
